;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;           This file is Freescale Confidential Proprietary
;           (C) Copyright Freescale 2006 ALL RIGHTS RESERVED
;
;   Initialize the System L2RAM for Copperhead
;
;   J. West
;   04/01/03
;   Notes:
;       Register r11 and r12 are corrupted, other
;       registers are not changed.  This routine can
;       be called from anywhere. r11,r12 are volatile
;       registers and maybe modified without saving.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.global init_L2RAM

.section .text  

init_L2RAM:

    lis r11,0x4000              ; base address of the RAM
    ori r11,r11,0

    li  r12,512                 ; loop counter to get all of RAM
    mtctr r12

init_l2ram_loop:
    stmw    r0,0(r11)           ; write all 32 registers to L2RAM
    addi    r11,r11,128         ; inc the ram ptr
    bdnz    init_l2ram_loop     ; loop for 64k of L2RAM
    blr                         ; done
